
package mage.cards.p;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author cbt33
 */
public final class PardicSwordsmith extends CardImpl {

    public PardicSwordsmith(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{R}");
        this.subtype.add(SubType.DWARF);

        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // {R}, Discard a card at random: Pardic Swordsmith gets +2/+0 until end of turn.
        Ability ability = new SimpleActivatedAbility(new BoostSourceEffect(2, 0, Duration.EndOfTurn), new ManaCostsImpl<>("{R}"));
        ability.addCost(new DiscardCardCost(true));
        this.addAbility(ability);
    }

    private PardicSwordsmith(final PardicSwordsmith card) {
        super(card);
    }

    @Override
    public PardicSwordsmith copy() {
        return new PardicSwordsmith(this);
    }
}
