
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.LeavesBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.DestroyAttachedToEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FadingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author LoneFox
 */
public final class ParallaxDementia extends CardImpl {

    public ParallaxDementia(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{1}{B}");
        this.subtype.add(SubType.AURA);

        // Enchant creature
        TargetPermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.getSpellAbility().addEffect(new AttachEffect(Outcome.BoostCreature));
        Ability ability = new EnchantAbility(auraTarget);
        this.addAbility(ability);
        // Fading 1
        this.addAbility(new FadingAbility(1, this));
        // Enchanted creature gets +3/+2.
        this.addAbility(new SimpleStaticAbility(new BoostEnchantedEffect(3, 2, Duration.WhileOnBattlefield)));
        // When Parallax Dementia leaves the battlefield, destroy enchanted creature. That creature can't be regenerated.
        this.addAbility(new LeavesBattlefieldTriggeredAbility(new DestroyAttachedToEffect("enchanted creature", true), false));
    }

    private ParallaxDementia(final ParallaxDementia card) {
        super(card);
    }

    @Override
    public ParallaxDementia copy() {
        return new ParallaxDementia(this);
    }
}
