

package mage.cards.p;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.combat.CanBlockAdditionalCreatureEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author BetaSteward_at_googlemail.com
 */
public final class PalaceGuard extends CardImpl {

    public PalaceGuard(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{W}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.SOLDIER);

        this.power = new MageInt(1);
        this.toughness = new MageInt(4);

        // Palace Guard can block any number of creatures.
        this.addAbility(new SimpleStaticAbility(new CanBlockAdditionalCreatureEffect(0)));
    }

    private PalaceGuard(final PalaceGuard card) {
        super(card);
    }

    @Override
    public PalaceGuard copy() {
        return new PalaceGuard(this);
    }
}
