
package mage.cards.o;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.target.TargetPlayer;
import mage.target.common.TargetCardInYourGraveyard;

/**
 *
 * @author LoneFox
 */
public final class OrganGrinder extends CardImpl {

    public OrganGrinder(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{B}");
        this.subtype.add(SubType.ZOMBIE);
        this.power = new MageInt(3);
        this.toughness = new MageInt(1);

        // {tap}, Exile three cards from your graveyard: Target player loses 3 life.
        Ability ability = new SimpleActivatedAbility(new LoseLifeTargetEffect(3), new TapSourceCost());
        ability.addCost(new ExileFromGraveCost(new TargetCardInYourGraveyard(3, 3, new FilterCard("cards from your graveyard"))));
        ability.addTarget(new TargetPlayer());
        this.addAbility(ability);
    }

    private OrganGrinder(final OrganGrinder card) {
        super(card);
    }

    @Override
    public OrganGrinder copy() {
        return new OrganGrinder(this);
    }
}
