
package mage.cards.o;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.PreventDamageToSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author djbrez
 */
public final class OrdruunCommando extends CardImpl {

    public OrdruunCommando(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{3}{R}");
        this.subtype.add(SubType.MINOTAUR);
        this.subtype.add(SubType.SOLDIER);
        this.power = new MageInt(4);
        this.toughness = new MageInt(1);

        // {W}: Prevent the next 1 damage that would be dealt to Ordruun Commando this turn.
        this.addAbility(new SimpleActivatedAbility(new PreventDamageToSourceEffect(Duration.EndOfTurn, 1), new ManaCostsImpl<>("{W}")));
    }

    private OrdruunCommando(final OrdruunCommando card) {
        super(card);
    }

    @Override
    public OrdruunCommando copy() {
        return new OrdruunCommando(this);
    }
}
