
package mage.cards.o;

import java.util.UUID;
import mage.MageInt;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.CantBeRegeneratedTargetEffect;
import mage.abilities.effects.common.RegenerateTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author fireshoes
 */
public final class OrcishHealer extends CardImpl {

    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("black or green creature");

    static {
        filter.add(Predicates.or(
                new ColorPredicate(ObjectColor.BLACK),
                new ColorPredicate(ObjectColor.GREEN)));
    }

    public OrcishHealer(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{R}{R}");
        this.subtype.add(SubType.ORC);
        this.subtype.add(SubType.CLERIC);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // {R}{R}, {tap}: Target creature can't be regenerated this turn.
        Ability ability = new SimpleActivatedAbility(new CantBeRegeneratedTargetEffect(Duration.EndOfTurn), new ManaCostsImpl<>("{R}{R}"));
        ability.addCost(new TapSourceCost());
        ability.addTarget(new TargetCreaturePermanent());
        this.addAbility(ability);

        // {B}{B}{R}, {tap}: Regenerate target black or green creature.
        ability = new SimpleActivatedAbility(new RegenerateTargetEffect(), new ManaCostsImpl<>("{B}{B}{R}"));
        ability.addCost(new TapSourceCost());
        ability.addTarget(new TargetCreaturePermanent(filter));
        this.addAbility(ability);

        // {R}{G}{G}, {tap}: Regenerate target black or green creature.
        ability = new SimpleActivatedAbility(new RegenerateTargetEffect(), new ManaCostsImpl<>("{R}{G}{G}"));
        ability.addCost(new TapSourceCost());
        ability.addTarget(new TargetCreaturePermanent(filter));
        this.addAbility(ability);
    }

    private OrcishHealer(final OrcishHealer card) {
        super(card);
    }

    @Override
    public OrcishHealer copy() {
        return new OrcishHealer(this);
    }
}
