package mage.cards.o;

import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.DiesThisOrAnotherTriggeredAbility;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.target.common.TargetControlledCreaturePermanent;

import java.util.UUID;

/**
 * @author TheElk801
 */
public final class OdricsOutrider extends CardImpl {

    public OdricsOutrider(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{3}{W}");

        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.KNIGHT);
        this.power = new MageInt(2);
        this.toughness = new MageInt(4);

        // Whenever Odric's Outrider or another creature you control dies, put a +1/+1 counter on target creature you control.
        Ability ability = new DiesThisOrAnotherTriggeredAbility(
                new AddCountersTargetEffect(CounterType.P1P1.createInstance()),
                false, StaticFilters.FILTER_CONTROLLED_CREATURE
        );
        ability.addTarget(new TargetControlledCreaturePermanent());
        this.addAbility(ability);
    }

    private OdricsOutrider(final OdricsOutrider card) {
        super(card);
    }

    @Override
    public OdricsOutrider copy() {
        return new OdricsOutrider(this);
    }
}
