
package mage.cards.n;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.keyword.BestowAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author Quercitron
 */
public final class NyxbornEidolon extends CardImpl {

    public NyxbornEidolon(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT,CardType.CREATURE},"{1}{B}");
        this.subtype.add(SubType.SPIRIT);

        this.power = new MageInt(2);
        this.toughness = new MageInt(1);

        // Bestow {4}{B}
        this.addAbility(new BestowAbility(this, "{4}{B}"));
        // Enchanted creature gets +2/+1.
        this.addAbility(new SimpleStaticAbility(new BoostEnchantedEffect(2, 1, Duration.WhileOnBattlefield)));
    }

    private NyxbornEidolon(final NyxbornEidolon card) {
        super(card);
    }

    @Override
    public NyxbornEidolon copy() {
        return new NyxbornEidolon(this);
    }
}
