
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.game.permanent.token.PestToken;

/**
 * @author Loki
 */
public final class NuisanceEngine extends CardImpl {

    public NuisanceEngine(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{3}");
        Ability ability = new SimpleActivatedAbility(new CreateTokenEffect(new PestToken(), 1), new GenericManaCost(2));
        ability.addCost(new TapSourceCost());
        this.addAbility(ability);
    }

    private NuisanceEngine(final NuisanceEngine card) {
        super(card);
    }

    @Override
    public NuisanceEngine copy() {
        return new NuisanceEngine(this);
    }
}
