package mage.cards.n;

import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.dynamicvalue.common.ArtifactYouControlCount;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.hint.common.ArtifactYouControlHint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;

import java.util.UUID;

/**
 * @author Plopman
 */
public final class NimGrotesque extends CardImpl {

    public NimGrotesque(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{6}{B}");
        this.subtype.add(SubType.ZOMBIE);

        this.power = new MageInt(3);
        this.toughness = new MageInt(6);

        // Nim Grotesque gets +1/+0 for each artifact you control.
        this.addAbility(new SimpleStaticAbility(
                new BoostSourceEffect(ArtifactYouControlCount.instance, StaticValue.get(0), Duration.WhileOnBattlefield))
                .addHint(ArtifactYouControlHint.instance)
        );
    }

    private NimGrotesque(final NimGrotesque card) {
        super(card);
    }

    @Override
    public NimGrotesque copy() {
        return new NimGrotesque(this);
    }
}
