
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.MillCardsTargetEffect;
import mage.abilities.mana.ColorlessManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.target.TargetPlayer;

/**
 * @author nantuko
 */
public final class NephaliaDrownyard extends CardImpl {

    public NephaliaDrownyard(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.LAND},"");

        // {T}: Add 1.
        this.addAbility(new ColorlessManaAbility());

        // {1}{U}{B}, {T}: Target player puts the top three cards of their library into their graveyard.
        Ability ability = new SimpleActivatedAbility(new MillCardsTargetEffect(3), new ManaCostsImpl<>("{1}{U}{B}"));
        ability.addCost(new TapSourceCost());
        ability.addTarget(new TargetPlayer());
        this.addAbility(ability);
    }

    private NephaliaDrownyard(final NephaliaDrownyard card) {
        super(card);
    }

    @Override
    public NephaliaDrownyard copy() {
        return new NephaliaDrownyard(this);
    }
}
