
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.ReturnToHandFromBattlefieldSourceCost;
import mage.abilities.effects.common.RegenerateTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author Loki
 */
public final class MoltingSkin extends CardImpl {

    public MoltingSkin(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{2}{G}");

        // Return Molting Skin to its owner's hand: Regenerate target creature.
        Ability ability = new SimpleActivatedAbility(new RegenerateTargetEffect(), new ReturnToHandFromBattlefieldSourceCost());
        ability.addTarget(new TargetCreaturePermanent());
        this.addAbility(ability);
    }

    private MoltingSkin(final MoltingSkin card) {
        super(card);
    }

    @Override
    public MoltingSkin copy() {
        return new MoltingSkin(this);
    }
}
