
package mage.cards.m;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.common.RegenerateSourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author Quercitron
 */
public final class MischievousPoltergeist extends CardImpl {

    public MischievousPoltergeist(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{B}");
        this.subtype.add(SubType.SPIRIT);

        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Flying
        this.addAbility(FlyingAbility.getInstance());
        // Pay 1 life: Regenerate Mischievous Poltergeist.
        this.addAbility(new SimpleActivatedAbility(new RegenerateSourceEffect(), new PayLifeCost(1)));
    }

    private MischievousPoltergeist(final MischievousPoltergeist card) {
        super(card);
    }

    @Override
    public MischievousPoltergeist copy() {
        return new MischievousPoltergeist(this);
    }
}
