
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTappedAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.mana.BlackManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.filter.common.FilterCreatureCard;
import mage.target.common.TargetCardInYourGraveyard;

/**
 * @author Rystan
 */
public final class MemorialToFolly extends CardImpl {

    public MemorialToFolly(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.LAND}, "");

        // Memorial to Folly enters the battlefield tapped.
        this.addAbility(new EntersBattlefieldTappedAbility());

        this.addAbility(new BlackManaAbility());

        // {2}{B}, {T}, Sacrifice Memorial to Folly: Return target creature card from your graveyard to your hand.
        Ability ability = new SimpleActivatedAbility(new ReturnToHandTargetEffect()
                .setText("Return target creature card from your graveyard to your hand"),
                new ManaCostsImpl<>("{2}{B}"));
        ability.addCost(new TapSourceCost());
        ability.addCost(new SacrificeSourceCost());
        ability.addTarget(new TargetCardInYourGraveyard(new FilterCreatureCard("creature card from your graveyard")));
        this.addAbility(ability);

    }

    private MemorialToFolly(final MemorialToFolly card) {
        super(card);
    }

    @Override
    public MemorialToFolly copy() {
        return new MemorialToFolly(this);
    }

}
