
package mage.cards.m;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.common.DrawDiscardControllerEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author LoneFox
 */
public final class MagusOfTheBazaar extends CardImpl {

    public MagusOfTheBazaar(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{U}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.WIZARD);
        this.power = new MageInt(0);
        this.toughness = new MageInt(1);

        // {tap}: Draw two cards, then discard three cards.
        this.addAbility(new SimpleActivatedAbility(new DrawDiscardControllerEffect(2, 3), new TapSourceCost()));                                                                          }

    private MagusOfTheBazaar(final MagusOfTheBazaar card) {
        super(card);
    }

    @Override
    public MagusOfTheBazaar copy() {
        return new MagusOfTheBazaar(this);
    }
}
