
package mage.cards.m;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.target.common.TargetAnyTarget;

/**
 *
 * @author LevelX2
 */
public final class MagmaticForce extends CardImpl {

    public MagmaticForce(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{5}{R}{R}{R}");
        this.subtype.add(SubType.ELEMENTAL);

        this.power = new MageInt(7);
        this.toughness = new MageInt(7);

        // At the beginning of each upkeep, Magmatic Force deals 3 damage to any target.
        Ability ability = new BeginningOfUpkeepTriggeredAbility(TargetController.ANY, new DamageTargetEffect(3), false);
        ability.addTarget(new TargetAnyTarget());        
        this.addAbility(ability);
    }

    private MagmaticForce(final MagmaticForce card) {
        super(card);
    }

    @Override
    public MagmaticForce copy() {
        return new MagmaticForce(this);
    }
}
