package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Outcome;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author Plopman
 */
public final class MadcapSkills extends CardImpl {

    public MadcapSkills(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{1}{R}");
        this.subtype.add(SubType.AURA);

        // Enchant creature
        TargetPermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.getSpellAbility().addEffect(new AttachEffect(Outcome.AddAbility));
        Ability ability = new EnchantAbility(auraTarget);
        this.addAbility(ability);
        
        // Enchanted creature gets +3/+0 and and has menace. (It can't be blocked except by two or more creatures.)
        Ability staticAbility = new SimpleStaticAbility(new BoostEnchantedEffect(3, 0));
        staticAbility.addEffect(new GainAbilityAttachedEffect(new MenaceAbility(false), AttachmentType.AURA)
                .setText("and has menace"));
        this.addAbility(staticAbility);
    }

    private MadcapSkills(final MadcapSkills card) {
        super(card);
    }

    @Override
    public MadcapSkills copy() {
        return new MadcapSkills(this);
    }
}
