
package mage.cards.l;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.GainAbilityPairedEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.SoulbondAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author noxx

 */
public final class LightningMauler extends CardImpl {

    private static final String ruleText = "As long as {this} is paired with another creature, both creatures have haste";

    public LightningMauler(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{R}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.BERSERKER);

        this.power = new MageInt(2);
        this.toughness = new MageInt(1);

        // Soulbond
        this.addAbility(new SoulbondAbility());

        // As long as Lightning Mauler is paired with another creature, both creatures have haste.
        this.addAbility(new SimpleStaticAbility(new GainAbilityPairedEffect(HasteAbility.getInstance(), ruleText)));
    }

    private LightningMauler(final LightningMauler card) {
        super(card);
    }

    @Override
    public LightningMauler copy() {
        return new LightningMauler(this);
    }
}
