package mage.cards.l;

import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.target.common.TargetAnyTarget;

import java.util.UUID;

/**
 * @author Loki
 */
public final class LightningHelix extends CardImpl {

    public LightningHelix(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{R}{W}");

        // Lightning Helix deals 3 damage to any target and you gain 3 life.
        this.getSpellAbility().addTarget(new TargetAnyTarget());
        this.getSpellAbility().addEffect(new DamageTargetEffect(3));
        this.getSpellAbility().addEffect(new GainLifeEffect(3).concatBy("and"));
    }

    private LightningHelix(final LightningHelix card) {
        super(card);
    }

    @Override
    public LightningHelix copy() {
        return new LightningHelix(this);
    }

}
