
package mage.cards.l;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author LoneFox
 */
public final class LeapingLizard extends CardImpl {

    public LeapingLizard(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{G}{G}");
        this.subtype.add(SubType.LIZARD);
        this.power = new MageInt(2);
        this.toughness = new MageInt(3);

        // {1}{G}: Leaping Lizard gets -0/-1 and gains flying until end of turn.
        Effect effect = new BoostSourceEffect(0, -1, Duration.EndOfTurn);
        effect.setText("{this} gets -0/-1");
        Ability ability = new SimpleActivatedAbility(effect, new ManaCostsImpl<>("{1}{G}"));
        effect = new GainAbilitySourceEffect(FlyingAbility.getInstance(), Duration.EndOfTurn);
        effect.setText("and gains flying until end of turn");
        ability.addEffect(effect);
        this.addAbility(ability);
    }

    private LeapingLizard(final LeapingLizard card) {
        super(card);
    }

    @Override
    public LeapingLizard copy() {
        return new LeapingLizard(this);
    }
}
