
package mage.cards.k;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.keyword.ReachAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author LevelX2
 */
public final class KrosanArcher extends CardImpl {

    public KrosanArcher(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{3}{G}");
        this.subtype.add(SubType.CENTAUR);
        this.subtype.add(SubType.ARCHER);

        this.power = new MageInt(2);
        this.toughness = new MageInt(3);

        // Reach
        this.addAbility(ReachAbility.getInstance());
        // {G}, Discard a card: Krosan Archer gets +0/+2 until end of turn.
        Ability ability = new SimpleActivatedAbility(new BoostSourceEffect(0,2, Duration.EndOfTurn), new ManaCostsImpl<>("{G}"));
        ability.addCost(new DiscardCardCost());
        this.addAbility(ability);
    }

    private KrosanArcher(final KrosanArcher card) {
        super(card);
    }

    @Override
    public KrosanArcher copy() {
        return new KrosanArcher(this);
    }
}
