

package mage.cards.k;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author Loki
 */
public final class Kranioceros extends CardImpl {

    public Kranioceros(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{4}{R}");
        this.subtype.add(SubType.BEAST);

        this.power = new MageInt(5);
        this.toughness = new MageInt(2);

        this.addAbility(new SimpleActivatedAbility(new BoostSourceEffect(0, 3, Duration.EndOfTurn), new ManaCostsImpl<>("{1}{W}")));
    }

    private Kranioceros(final Kranioceros card) {
        super(card);
    }

    @Override
    public Kranioceros copy() {
        return new Kranioceros(this);
    }
}
