
package mage.cards.k;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.GainProtectionFromColorSourceEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author LoneFox
 */
public final class KnightOfDawn extends CardImpl {

    public KnightOfDawn(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{W}{W}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.KNIGHT);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // First strike
        this.addAbility(FirstStrikeAbility.getInstance());
        // {W}{W}: Knight of Dawn gains protection from the color of your choice until end of turn.
        this.addAbility(new SimpleActivatedAbility(new GainProtectionFromColorSourceEffect(Duration.EndOfTurn), new ManaCostsImpl<>("{W}{W}")));
    }

    private KnightOfDawn(final KnightOfDawn card) {
        super(card);
    }

    @Override
    public KnightOfDawn copy() {
        return new KnightOfDawn(this);
    }
}
