package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.mana.ColorlessManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.game.permanent.token.KherKeepKoboldToken;

/**
 *
 * @author LevelX2
 */
public final class KherKeep extends CardImpl {

    public KherKeep(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.LAND}, "");
        this.supertype.add(SuperType.LEGENDARY);

        // {T}: Add {C}.
        this.addAbility(new ColorlessManaAbility());

        // {1}{R}, {T}: Create a 0/1 red Kobold creature token named Kobolds of Kher Keep.
        Ability ability = new SimpleActivatedAbility(new CreateTokenEffect(new KherKeepKoboldToken()), new ManaCostsImpl<>("{1}{R}"));
        ability.addCost(new TapSourceCost());
        this.addAbility(ability);
    }

    private KherKeep(final KherKeep card) {
        super(card);
    }

    @Override
    public KherKeep copy() {
        return new KherKeep(this);
    }
}
