
package mage.cards.j;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.CounterUnlessPaysEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.target.TargetSpell;

/**
 *
 * @author LevelX2
 */
public final class JudgesFamiliar extends CardImpl {

    public JudgesFamiliar(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{W/U}");
        this.subtype.add(SubType.BIRD);


        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Flying
        this.addAbility(FlyingAbility.getInstance());

        // Sacrifice Judge's Familiar: Counter target instant or sorcery spell unless its controller pays {1}.
        SimpleActivatedAbility ability = new SimpleActivatedAbility(
                new CounterUnlessPaysEffect(new GenericManaCost(1)),
                new SacrificeSourceCost());
        ability.addTarget(new TargetSpell(StaticFilters.FILTER_SPELL_INSTANT_OR_SORCERY));
        this.addAbility(ability);
    }

    private JudgesFamiliar(final JudgesFamiliar card) {
        super(card);
    }

    @Override
    public JudgesFamiliar copy() {
        return new JudgesFamiliar(this);
    }
}
