
package mage.cards.i;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.combat.CanBlockAdditionalCreatureEffect;
import mage.abilities.keyword.MorphAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author fireshoes
 */
public final class IronfistCrusher extends CardImpl {

    public IronfistCrusher(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{4}{W}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.SOLDIER);
        this.power = new MageInt(2);
        this.toughness = new MageInt(4);

        // Ironfist Crusher can block any number of creatures.
        this.addAbility(new SimpleStaticAbility(new CanBlockAdditionalCreatureEffect(0)));
        
        // Morph {3}{W}
        this.addAbility(new MorphAbility(this, new ManaCostsImpl<>("{3}{W}")));
    }

    private IronfistCrusher(final IronfistCrusher card) {
        super(card);
    }

    @Override
    public IronfistCrusher copy() {
        return new IronfistCrusher(this);
    }
}
