
package mage.cards.i;

import java.util.UUID;
import mage.abilities.effects.common.PreventNextDamageFromChosenSourceToYouEffect;
import mage.abilities.keyword.BuybackAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;

/**
 *
 * @author anonymous
 */
public final class Invulnerability extends CardImpl {

    public Invulnerability(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.INSTANT},"{1}{W}");

        // Buyback {3}
        this.addAbility(new BuybackAbility("{3}"));
        
        // The next time a source of your choice would deal damage to you this turn, prevent that damage.
        this.getSpellAbility().addEffect(new PreventNextDamageFromChosenSourceToYouEffect(Duration.EndOfTurn));
    }

    private Invulnerability(final Invulnerability card) {
        super(card);
    }

    @Override
    public Invulnerability copy() {
        return new Invulnerability(this);
    }
}

