
package mage.cards.i;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.FearAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.StaticFilters;

/**
 *
 * @author Galatolol
 */
public final class Intimidation extends CardImpl {

    public Intimidation(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{B}{B}{B}");

        // Creatures you control have fear.
        this.addAbility(new SimpleStaticAbility(new GainAbilityControlledEffect(FearAbility.getInstance(), Duration.WhileOnBattlefield, StaticFilters.FILTER_PERMANENT_CREATURES)));
    }

    private Intimidation(final Intimidation card) {
        super(card);
    }

    @Override
    public Intimidation copy() {
        return new Intimidation(this);
    }
}
