package mage.cards.i;

import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.filter.StaticFilters;
import mage.target.common.TargetAnyTarget;

import java.util.UUID;

/**
 * @author TheElk801
 */
public final class ImprovisedClub extends CardImpl {

    public ImprovisedClub(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{R}");

        // As an additional cost to cast this spell, sacrifice an artifact or creature.
        this.getSpellAbility().addCost(new SacrificeTargetCost(
                StaticFilters.FILTER_PERMANENT_ARTIFACT_OR_CREATURE
        ));

        // Improvised Club deals 4 damage to any target.
        this.getSpellAbility().addEffect(new DamageTargetEffect(4));
        this.getSpellAbility().addTarget(new TargetAnyTarget());
    }

    private ImprovisedClub(final ImprovisedClub card) {
        super(card);
    }

    @Override
    public ImprovisedClub copy() {
        return new ImprovisedClub(this);
    }
}
