
package mage.cards.h;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author LoneFox
 */
public final class HyalopterousLemure extends CardImpl {

    public HyalopterousLemure(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{4}{B}");
        this.subtype.add(SubType.SPIRIT);
        this.power = new MageInt(4);
        this.toughness = new MageInt(3);

        // {0}: Hyalopterous Lemure gets -1/-0 and gains flying until end of turn.
        Effect effect = new BoostSourceEffect(-1, 0, Duration.EndOfTurn);
        effect.setText("{this} gets -1/-0");
        Ability ability = new SimpleActivatedAbility(effect, new ManaCostsImpl<>("{0}"));
        effect = new GainAbilitySourceEffect(FlyingAbility.getInstance(), Duration.EndOfTurn);
        effect.setText("and gains flying until end of turn");
        ability.addEffect(effect);
        this.addAbility(ability);
    }

    private HyalopterousLemure(final HyalopterousLemure card) {
        super(card);
    }

    @Override
    public HyalopterousLemure copy() {
        return new HyalopterousLemure(this);
    }
}
