
package mage.cards.h;

import java.util.UUID;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicates;
import mage.target.TargetPermanent;

/**
 *
 * @author markedagain
 */
public final class Hoodwink extends CardImpl {

    private static final FilterPermanent filter = new FilterPermanent("artifact, enchantment, or land");
    
    static {
        filter.add(Predicates.or(
                CardType.ARTIFACT.getPredicate(),
                CardType.ENCHANTMENT.getPredicate(),
                CardType.LAND.getPredicate()));
    }
    public Hoodwink(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.INSTANT},"{1}{U}");

        // Return target artifact, enchantment, or land to its owner's hand.
        this.getSpellAbility().addEffect(new ReturnToHandTargetEffect());
        this.getSpellAbility().addTarget(new TargetPermanent(filter));
    }

    private Hoodwink(final Hoodwink card) {
        super(card);
    }

    @Override
    public Hoodwink copy() {
        return new Hoodwink(this);
    }
}
