package mage.cards.h;

import mage.MageInt;
import mage.Mana;
import mage.abilities.common.EntersBattlefieldControlledTriggeredAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.dynamicvalue.common.SourcePermanentPowerValue;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.keyword.VigilanceAbility;
import mage.abilities.mana.DynamicManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.mageobject.AnotherPredicate;

import java.util.UUID;

/**
 * @author TheElk801
 */
public final class HeronbladeElite extends CardImpl {

    private static final FilterPermanent filter = new FilterCreaturePermanent(SubType.HUMAN, "another Human");

    static {
        filter.add(AnotherPredicate.instance);
    }

    public HeronbladeElite(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{G}");

        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.WARRIOR);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Vigilance
        this.addAbility(VigilanceAbility.getInstance());

        // Whenever another Human you control enters, put a +1/+1 counter on Heronblade Elite.
        this.addAbility(new EntersBattlefieldControlledTriggeredAbility(
                new AddCountersSourceEffect(CounterType.P1P1.createInstance()), filter
        ));

        // {T}: Add X mana of any one color, where X is Heronblade Elite's power.
        this.addAbility(new DynamicManaAbility(
                Mana.AnyMana(1), SourcePermanentPowerValue.NOT_NEGATIVE, new TapSourceCost(), "Add X mana "
                + "of any one color, where X is {this}'s power", true
        ));
    }

    private HeronbladeElite(final HeronbladeElite card) {
        super(card);
    }

    @Override
    public HeronbladeElite copy() {
        return new HeronbladeElite(this);
    }
}
