
package mage.cards.h;

import java.util.UUID;
import mage.target.common.TargetCreaturePermanent;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.MostCommonColorCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.constants.Outcome;
import mage.target.TargetPermanent;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

/**
 *
 * @author TheElk801
 */
public final class HeroicDefiance extends CardImpl {

    public HeroicDefiance(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{W}");

        this.subtype.add(SubType.AURA);

        // Enchant creature
        TargetPermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.getSpellAbility().addEffect(new AttachEffect(Outcome.BoostCreature));
        Ability ability = new EnchantAbility(auraTarget);
        this.addAbility(ability);

        // Enchanted creature gets +3/+3 unless it shares a color with the most common color among all permanents or a color tied for most common.
        this.addAbility(new SimpleStaticAbility(
                new ConditionalContinuousEffect(new BoostEnchantedEffect(3, 3, Duration.WhileOnBattlefield),
                        new HeroicDefianceCondition(),
                        "Enchanted creature gets +3/+3 unless it shares a color with the most common color among all permanents or a color tied for most common")));
    }

    private HeroicDefiance(final HeroicDefiance card) {
        super(card);
    }

    @Override
    public HeroicDefiance copy() {
        return new HeroicDefiance(this);
    }
}

class HeroicDefianceCondition implements Condition {

    public HeroicDefianceCondition() {
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null) {
            Permanent creature = game.getPermanent(enchantment.getAttachedTo());
            if (creature != null) {
                Condition condition = new MostCommonColorCondition(creature.getColor(game));
                return !condition.apply(game, source);
            }
        }
        return false;
    }
}
