package mage.cards.h;

import mage.MageInt;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.abilities.keyword.HeroicAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.StaticFilters;

import java.util.UUID;

/**
 * @author TheElk801
 */
public final class HeroOfThePride extends CardImpl {

    public HeroOfThePride(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{W}");

        this.subtype.add(SubType.CAT);
        this.subtype.add(SubType.SOLDIER);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // Whenever you cast a spell that targets Hero of the Pride, creatures you control get +1/+0 until end of turn.
        this.addAbility(new HeroicAbility(new BoostControlledEffect(
                1, 0, Duration.EndOfTurn, StaticFilters.FILTER_PERMANENT_CREATURES
        ), false, false));
    }

    private HeroOfThePride(final HeroOfThePride card) {
        super(card);
    }

    @Override
    public HeroOfThePride copy() {
        return new HeroOfThePride(this);
    }
}
