
package mage.cards.h;

import java.util.UUID;
import mage.MageInt;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author tomd1990
 */
public final class HellBentRaider extends CardImpl {

    public HellBentRaider(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{R}{R}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.BARBARIAN);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // First strike
        this.addAbility(FirstStrikeAbility.getInstance());
        // Haste
        this.addAbility(HasteAbility.getInstance());
        // Discard a card at random: Hell-Bent Raider gains protection from white until end of turn.
        Ability ability = new SimpleActivatedAbility(
                new GainAbilitySourceEffect(ProtectionAbility.from(ObjectColor.WHITE), Duration.EndOfTurn),
                new DiscardCardCost(true));
        this.addAbility(ability);
    }

    private HellBentRaider(final HellBentRaider card) {
        super(card);
    }

    @Override
    public HellBentRaider copy() {
        return new HellBentRaider(this);
    }
}
