
package mage.cards.h;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.target.common.TargetCardInGraveyard;

/**
 *
 * @author North
 */
public final class HeapDoll extends CardImpl {

    public HeapDoll(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT,CardType.CREATURE},"{1}");
        this.subtype.add(SubType.SCARECROW);

        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Sacrifice Heap Doll: Exile target card from a graveyard.
        SimpleActivatedAbility ability = new SimpleActivatedAbility(new ExileTargetEffect(), new SacrificeSourceCost());
        ability.addTarget(new TargetCardInGraveyard());
        this.addAbility(ability);
    }

    private HeapDoll(final HeapDoll card) {
        super(card);
    }

    @Override
    public HeapDoll copy() {
        return new HeapDoll(this);
    }
}
