
package mage.cards.h;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.keyword.DevoidAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author LevelX2
 */
public final class HavocSower extends CardImpl {

    public HavocSower(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{3}{B}");
        this.subtype.add(SubType.ELDRAZI);
        this.subtype.add(SubType.DRONE);
        this.power = new MageInt(3);
        this.toughness = new MageInt(3);

        // Devoid
        this.addAbility(new DevoidAbility(this.color));
        // {1}{C}: Havoc Sower gets +2/+1 until end of turn.
        this.addAbility(new SimpleActivatedAbility(new BoostSourceEffect(2, 1, Duration.EndOfTurn), new ManaCostsImpl<>("{1}{C}")));
    }

    private HavocSower(final HavocSower card) {
        super(card);
    }

    @Override
    public HavocSower copy() {
        return new HavocSower(this);
    }
}
