
package mage.cards.h;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.BoostOpponentsEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author LevelX2
 */
public final class HaunterOfNightveil extends CardImpl {

    public HaunterOfNightveil(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{3}{U}{B}");
        this.subtype.add(SubType.SPIRIT);

        this.power = new MageInt(3);
        this.toughness = new MageInt(4);

        // Creatures your opponents control get -1/-0.
        this.addAbility(new SimpleStaticAbility(new BoostOpponentsEffect(-1,0, Duration.WhileOnBattlefield)));
    }

    private HaunterOfNightveil(final HaunterOfNightveil card) {
        super(card);
    }

    @Override
    public HaunterOfNightveil copy() {
        return new HaunterOfNightveil(this);
    }
}
