package mage.cards.h;

import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.MyTurnCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.hint.common.MyTurnHint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;

import java.util.UUID;

/**
 * @author LevelX2
 */
public final class HardyVeteran extends CardImpl {

    public HardyVeteran(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{G}");

        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.WARRIOR);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // As long as it's your turn, Hardy Veteran gets +0/+2.
        Effect boostEffect = new ConditionalContinuousEffect(
                new BoostSourceEffect(0, 2, Duration.WhileOnBattlefield),
                MyTurnCondition.instance,
                "During your turn, {this} gets +0/+2");
        Ability ability = new SimpleStaticAbility(boostEffect);
        ability.addHint(MyTurnHint.instance);
        this.addAbility(ability);
    }

    private HardyVeteran(final HardyVeteran card) {
        super(card);
    }

    @Override
    public HardyVeteran copy() {
        return new HardyVeteran(this);
    }
}
