
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.*;
import mage.filter.FilterObject;
import mage.filter.predicate.mageobject.MulticoloredPredicate;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author LevelX2
 */
public final class GuildscornWard extends CardImpl {

    private static final FilterObject filter = new FilterObject("multicolored");
    static {
        filter.add(MulticoloredPredicate.instance);
    }

    public GuildscornWard(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{W}");

        this.subtype.add(SubType.AURA);

        // Enchant creature
        TargetPermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.getSpellAbility().addEffect(new AttachEffect(Outcome.Protect));
        Ability ability = new EnchantAbility(auraTarget);
        this.addAbility(ability);

        // Enchanted creature has protection from multicolored.
        this.addAbility(new SimpleStaticAbility(new GainAbilityAttachedEffect(new ProtectionAbility(filter), AttachmentType.AURA, Duration.WhileOnBattlefield)));
    }

    private GuildscornWard(final GuildscornWard card) {
        super(card);
    }

    @Override
    public GuildscornWard copy() {
        return new GuildscornWard(this);
    }
}
