
package mage.cards.g;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.DrawDiscardControllerEffect;
import mage.abilities.effects.common.combat.CantBlockTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author Plopman
 */
public final class GrixisBattlemage extends CardImpl {

    public GrixisBattlemage(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{B}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.WIZARD);

        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // {U}, {tap}: Draw a card, then discard a card.
        Ability ability1 = new SimpleActivatedAbility(new DrawDiscardControllerEffect(), new ManaCostsImpl<>("{U}"));
        ability1.addCost(new TapSourceCost());
        this.addAbility(ability1);
        // {R}, {tap}: Target creature can't block this turn.
        Ability ability2 = new SimpleActivatedAbility(new CantBlockTargetEffect(Duration.EndOfTurn), new ManaCostsImpl<>("{R}"));
        ability2.addCost(new TapSourceCost());
        ability2.addTarget(new TargetCreaturePermanent());
        this.addAbility(ability2);
    }

    private GrixisBattlemage(final GrixisBattlemage card) {
        super(card);
    }

    @Override
    public GrixisBattlemage copy() {
        return new GrixisBattlemage(this);
    }
}
