package mage.cards.g;

import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.dynamicvalue.common.SourcePermanentPowerValue;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.keyword.BloodthirstAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

import java.util.UUID;

/**
 *
 * @author escplan9 (Derek Monturo - dmontur1 at gmail dot com)
 */
public final class Gristleback extends CardImpl {

    public Gristleback(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{G}");
        this.subtype.add(SubType.BOAR);
        this.subtype.add(SubType.BEAST);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // Bloodthirst 1
        this.addAbility(new BloodthirstAbility(1));
        
        // Sacrifice Gristleback: You gain life equal to Gristleback's power.
        this.addAbility(new SimpleActivatedAbility(
                new GainLifeEffect(SourcePermanentPowerValue.NOT_NEGATIVE).setText("You gain life equal to {this}'s power"),
                new SacrificeSourceCost()));
    }

    private Gristleback(final Gristleback card) {
        super(card);
    }

    @Override
    public Gristleback copy() {
        return new Gristleback(this);
    }
}
