package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.combat.AttacksIfAbleAllEffect;
import mage.abilities.effects.common.combat.BlocksIfAbleAllEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.filter.StaticFilters;

/**
 *
 * @author fenhl
 */
public final class GrandMelee extends CardImpl {

    public GrandMelee(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{3}{R}");

        // All creatures attack each turn if able.
        Ability ability = new SimpleStaticAbility(new AttacksIfAbleAllEffect(StaticFilters.FILTER_PERMANENT_ALL_CREATURES));
        this.addAbility(ability);

        // All creatures block each turn if able.
        this.addAbility(new SimpleStaticAbility(new BlocksIfAbleAllEffect(StaticFilters.FILTER_PERMANENT_ALL_CREATURES)));
    }

    private GrandMelee(final GrandMelee card) {
        super(card);
    }

    @Override
    public GrandMelee copy() {
        return new GrandMelee(this);
    }
}
