
package mage.cards.g;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.PlayWithTheTopCardRevealedEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author michael.napoleon@gmail.com
 */
public final class GoblinSpy extends CardImpl {

    public GoblinSpy(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{R}");
        this.subtype.add(SubType.GOBLIN);
        this.subtype.add(SubType.ROGUE);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Play with the top card of your library revealed.
      this.addAbility(new SimpleStaticAbility(new PlayWithTheTopCardRevealedEffect()));
    }

    private GoblinSpy(final GoblinSpy card) {
        super(card);
    }

    @Override
    public GoblinSpy copy() {
        return new GoblinSpy(this);
    }
}
