
package mage.cards.g;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.dynamicvalue.common.EquipmentAttachedCount;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author North
 */
public final class GoblinGaveleer extends CardImpl {

    public GoblinGaveleer(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{R}");
        this.subtype.add(SubType.GOBLIN);
        this.subtype.add(SubType.WARRIOR);

        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Trample
        this.addAbility(TrampleAbility.getInstance());
        // Goblin Gaveleer gets +2/+0 for each Equipment attached to it.
        this.addAbility(new SimpleStaticAbility(new BoostSourceEffect(new EquipmentAttachedCount(2),
                StaticValue.get(0), Duration.WhileOnBattlefield)));
    }

    private GoblinGaveleer(final GoblinGaveleer card) {
        super(card);
    }

    @Override
    public GoblinGaveleer copy() {
        return new GoblinGaveleer(this);
    }
}
