
package mage.cards.g;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterControlledPermanent;
import mage.target.common.TargetControlledPermanent;

/**
 *
 * @author North
 */
public final class Gnathosaur extends CardImpl {

    private static final FilterControlledPermanent filter = new FilterControlledPermanent("an artifact");

    static {
        filter.add(CardType.ARTIFACT.getPredicate());
    }

    public Gnathosaur(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{4}{R}{R}");
        this.subtype.add(SubType.DINOSAUR);

        this.power = new MageInt(5);
        this.toughness = new MageInt(4);

        this.addAbility(new SimpleActivatedAbility(
                new GainAbilitySourceEffect(TrampleAbility.getInstance(), Duration.EndOfTurn),
                new SacrificeTargetCost(filter)));
    }

    private Gnathosaur(final Gnathosaur card) {
        super(card);
    }

    @Override
    public Gnathosaur copy() {
        return new Gnathosaur(this);
    }
}
