
package mage.cards.g;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.TargetController;

/**
 *
 * @author LevelX2
 */
public final class Glitterfang extends CardImpl {

    public Glitterfang(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{R}");
        this.subtype.add(SubType.SPIRIT);

        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Haste
        this.addAbility(HasteAbility.getInstance());
        // At the beginning of the end step, return Glitterfang to its owner's hand.
        this.addAbility(new BeginningOfEndStepTriggeredAbility(TargetController.NEXT, new ReturnToHandSourceEffect(true), false));
    }

    private Glitterfang(final Glitterfang card) {
        super(card);
    }

    @Override
    public Glitterfang copy() {
        return new Glitterfang(this);
    }
}
