
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.combat.CanBlockAdditionalCreatureEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author LevelX2
 */
public final class GiveNoGround extends CardImpl {

    public GiveNoGround(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.INSTANT},"{3}{W}");

        // Target creature gets +2/+6 until end of turn and can block any number of creatures this turn.
        this.getSpellAbility().addTarget(new TargetCreaturePermanent());
        this.getSpellAbility().addEffect(new BoostTargetEffect(2, 6, Duration.EndOfTurn));
        Ability gainedAbility = new SimpleStaticAbility(new CanBlockAdditionalCreatureEffect(0));
        Effect effect = new GainAbilityTargetEffect(gainedAbility, Duration.EndOfTurn);
        effect.setText("and can block any number of creatures this turn");
        this.getSpellAbility().addEffect(effect);
    }

    private GiveNoGround(final GiveNoGround card) {
        super(card);
    }

    @Override
    public GiveNoGround copy() {
        return new GiveNoGround(this);
    }
}
