
package mage.cards.g;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author hanasu
 */
public final class GhostsOfTheDamned extends CardImpl {

    public GhostsOfTheDamned(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{B}{B}");
        this.subtype.add(SubType.SPIRIT);
        this.power = new MageInt(0);
        this.toughness = new MageInt(2);

        // {tap}: Target creature gets -1/-0 until end of turn.
        Ability ability = new SimpleActivatedAbility(new BoostTargetEffect(-1, 0, Duration.EndOfTurn), new TapSourceCost());
        ability.addTarget(new TargetCreaturePermanent());
        this.addAbility(ability);
    }

    private GhostsOfTheDamned(final GhostsOfTheDamned card) {
        super(card);
    }

    @Override
    public GhostsOfTheDamned copy() {
        return new GhostsOfTheDamned(this);
    }
}
