
package mage.cards.g;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.ControlEnchantedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author BetaSteward
 */
public final class GhastlyHaunting extends CardImpl {

    public GhastlyHaunting(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"");
        this.subtype.add(SubType.AURA);
        this.color.setBlue(true);

        // this card is the second face of double-faced card
        this.nightCard = true;

        // Enchant creature
        TargetPermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.addAbility(new EnchantAbility(auraTarget));

        // You control enchanted creature.
        this.addAbility(new SimpleStaticAbility(new ControlEnchantedEffect()));
    }

    private GhastlyHaunting(final GhastlyHaunting card) {
        super(card);
    }

    @Override
    public GhastlyHaunting copy() {
        return new GhastlyHaunting(this);
    }
}
